/**
* INTEL CONFIDENTIAL
* Copyright 2013-2014 Intel Corporation All Rights Reserved.

* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its suppliers
* and licensors. The Material may contain trade secrets and proprietary and confidential
* information of Intel Corporation and its suppliers and licensors, and is protected
* by worldwide copyright and trade secret laws and treaty provisions. No part of
* the Material may be used, copied, reproduced, modified, published, uploaded, posted,
* transmitted, distributed, or disclosed in any way without Intel's prior express
* written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual property
* right is granted to or conferred upon you by disclosure or delivery of the Materials,
* either expressly, by implication, inducement, estoppel or otherwise. Any license under
* such intellectual property rights must be express and approved by Intel in writing.
*
* Unless otherwise agreed by Intel in writing, you may not remove or alter this notice
* or any other notice embedded in Materials by Intel or Intel's suppliers or licensors in any way.
*/

#ifndef SPIPUBLIC_H
#define SPIPUBLIC_H

/* Define an Interface Guid so that app can find the device and talk to it. */
/* {BADC33D6-BE37-4372-B90E-BBF2D986B0EB} */
DEFINE_GUID(GUID_BYT_SPI_DEVICE_INTERFACE,
            0xbadc33d6, 0xbe37, 0x4372, 0xb9, 0xe, 0xbb, 0xf2, 0xd9, 0x86, 0xb0, 0xeb);

#define FILE_DEVICE_SPI_PERIPHERAL 0x8002

#define IOCTL_SPI_READ              CTL_CODE(FILE_DEVICE_SPI_PERIPHERAL, 0x902, METHOD_DIRECT_FROM_HARDWARE, FILE_ANY_ACCESS)
#define IOCTL_SPI_WRITE             CTL_CODE(FILE_DEVICE_SPI_PERIPHERAL, 0x903, METHOD_DIRECT_TO_HARDWARE, FILE_ANY_ACCESS)
#define IOCTL_SPI_SEQUENCE          CTL_CODE(FILE_DEVICE_SPI_PERIPHERAL, 0x904, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define MAX_SEQUENCE_ENTRY_SIZE     2

typedef enum SPB_TRANSFER_DIRECTION
{
    SpbTransferDirectionNone,
    SpbTransferDirectionFromDevice,
    SpbTransferDirectionToDevice,
    SpbTransferDirectionMax
}
SPB_TRANSFER_DIRECTION, *PSPB_TRANSFER_DIRECTION;

typedef enum IO_SPI_MODE
{
    IO_SPI_MODE_0 = 0,
    IO_SPI_MODE_1 = 1,
    IO_SPI_MODE_2 = 2,
    IO_SPI_MODE_3 = 3,
    IO_SPI_MODE_MAX
} IO_SPI_MODE, *PIO_SPI_MODE;

__pragma(pack(push, 4))
typedef struct _SPI_TRANSFER_BUFFER
{
    UCHAR       Mode;
    UCHAR       BitsPerEntry;
    ULONG       ConnectionSpeed;

    UINT32      DataLength;
    PVOID       pBuffer;
} SPI_TRANSFER_BUFFER, *PSPI_TRANSFER_BUFFER;

typedef struct _SPI_TRANSFER_LIST_ENTRY
{

    SPB_TRANSFER_DIRECTION      Direction;
    UINT64                      DelayInUs;

    SPI_TRANSFER_BUFFER         SpiTransferBuffer;
} SPI_TRANSFER_LIST_ENTRY, *PSPI_TRANSFER_LIST_ENTRY;

typedef struct _SPI_TRANSFER_LIST
{
    UINT64                      Size;
    SPI_TRANSFER_LIST_ENTRY     List[MAX_SEQUENCE_ENTRY_SIZE];
} SPI_TRANSFER_LIST;

__pragma(pack(pop))


#endif